#include <iostream>
#include <vector>
#include <cstdlib>
using namespace std;

const int kMaxN = 55;

int c[kMaxN][kMaxN];

int ans[kMaxN][kMaxN];

int n;

void Calc(const vector<int>& verts)
{
    if (verts.size() <= 1) {
        return;
    }

    int min_cost = c[verts[0]][verts[1]];
    int A = verts[0];
    int B = verts[1];

    for (int i = 0; i < (int) verts.size(); ++i) {
        for (int j = i + 1; j < (int) verts.size(); ++j) {
            if (c[verts[i]][verts[j]] < min_cost) {
                min_cost = c[verts[i]][verts[j]];
                A = verts[i];
                B = verts[j];
            }
        }
    }

    ans[A][B] = ans[B][A] = c[A][B];

    vector<int> left;
    vector<int> right;

    for (int i = 0; i < (int) verts.size(); ++i) {
        if (i == A || i == B) {
            continue;
        }
        if (c[i][A] > c[A][B] && c[i][B] > c[A][B]) {
            cout << "NO" << endl;
            exit(0);
        } else if (c[i][A] == c[A][B]) {
            right.push_back(i);
        } else {
            left.push_back(i);
        }
    }

    for (int i = 0; i < (int) left.size(); ++i) {
        for (int j = 0; j < (int) right.size(); ++j) {
            int v1 = left[i];
            int v2 = right[j];

            if (c[v1][v2] != c[A][B]) {
                cout << "NO" << endl;
                exit(0);
            }
        }
    }

    left.push_back(A);

    right.push_back(B);

    Calc(left);
    Calc(right);
}

int main()
{
    ios_base::sync_with_stdio(false);

    cin >> n;
    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < n; ++j) {
            cin >> c[i][j];
        }
    }

    vector<int> verts(n);
    for (int i = 0; i < n; ++i) {
        verts[i] = i;
    }

    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < n; ++j) {
            ans[i][j] = -1;
        }
    }

    Calc(verts);

    cout << "YES" << endl;

    int ans_amount = 0;
    for (int i = 0; i < n; ++i) {
        for (int j = i + 1; j < n; ++j) {
            if (ans[i][j] != -1) {
                ++ans_amount;
            }
        }
    }

    cout << ans_amount << endl;
    for (int i = 0; i < n; ++i) {
        for (int j = i + 1; j < n; ++j) {
            if (ans[i][j] != -1) {
                cout << i + 1 << " " << j + 1 << " " << ans[i][j] << endl;
            }
        }
    }

    return 0;
}
